/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.blockentity;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import xueluoanping.teastory.block.entity.SyncedBlockEntity;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class TeaCupBlockEntity
extends SyncedBlockEntity {
    private final List<LazyOptional<FluidTank>> fluidTanks = Lists.newArrayList();

    public TeaCupBlockEntity(int capacity, BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.WOODEN_TRAY_TYPE.get(), pos, state);
        for (int i = 0; i < 3; ++i) {
            this.fluidTanks.add((LazyOptional<FluidTank>)LazyOptional.of(() -> this.createFluidHandler(capacity)));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fluidTanks.get(0).ifPresent(f -> f.readFromNBT(tag.m_128469_("FluidTank_0")));
        this.fluidTanks.get(1).ifPresent(f -> f.readFromNBT(tag.m_128469_("FluidTank_1")));
        this.fluidTanks.get(2).ifPresent(f -> f.readFromNBT(tag.m_128469_("FluidTank_2")));
    }

    protected void m_183515_(CompoundTag tag) {
        this.fluidTanks.get(0).ifPresent(f -> tag.m_128365_("FluidTank_0", (Tag)f.writeToNBT(new CompoundTag())));
        this.fluidTanks.get(1).ifPresent(f -> tag.m_128365_("FluidTank_1", (Tag)f.writeToNBT(new CompoundTag())));
        this.fluidTanks.get(2).ifPresent(f -> tag.m_128365_("FluidTank_2", (Tag)f.writeToNBT(new CompoundTag())));
        super.m_183515_(tag);
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TeaCupBlockEntity.this.inventoryChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return !stack.getFluid().getFluidType().isLighterThanAir() && stack.getFluid().getFluidType().getTemperature() < 500;
            }
        };
    }

    public FluidTank getFluidTank(int index) {
        return (FluidTank)this.fluidTanks.get(index).orElse((Object)new FluidTank(0));
    }

    public Fluid getFluid(int index) {
        return this.fluidTanks.get(index).map(f -> f.getFluid().getFluid()).orElse(Fluids.f_76191_);
    }

    public int getFluidAmount(int index) {
        return this.getFluidTank(index).getFluidAmount();
    }

    public void setFluidTank(int index, FluidStack stack) {
        this.fluidTanks.get(index).ifPresent(f -> f.setFluid(stack));
    }

    public void setFluid(int index, Fluid fluid) {
        this.fluidTanks.get(index).ifPresent(f -> f.setFluid(new FluidStack(fluid, this.getFluidAmount(index))));
        this.inventoryChanged();
    }
}

